cd "$root"

***** create gdpdata.dta *****
* generate index2016 tempfile
import excel using "raw_data/OECD_GDP.xlsx",sheet(US gdp deflator (FRED)) first clear 
keep Year Index2016
rename Year year
rename Index2016 igdp16
tempfile igdp16
save "`igdp16'", replace

* generate gdp temfile
import excel using "raw_data/OECD_GDP.xlsx",sheet(OECD nominal gdp in USD (OECD)) first clear 
keep LOCATION TIME Value
rename LOCATION ID
rename TIME year
rename Value gdp
tempfile gdp
save "`gdp'", replace

* import gdppc data
import excel using "raw_data/OECD_GDP.xlsx",sheet(OECD nominal gdppc in USD(OECD)) first clear 
keep LOCATION TIME Value
rename LOCATION ID
rename TIME year
rename Value gdppc

* merge with gdppc, igdp16, and names datasets
merge 1:1 ID year using "`gdp'" 
drop _merge
merge m:1 year using "`igdp16'"
drop _merge
merge m:1 ID using "data/names" 
drop if _merge==2
drop _merge

* generate real gdp gdppc
gen gdpR = gdp/igdp16*100
label var gdpR "real GDP $US 2016"
gen gdppcR = gdppc/igdp16*100
label var gdppcR "real per capital GDP $US 2016"
gen pop = gdp/gdppc
label var pop "population (millions)"

* save gdpdata
sort ID year
save "data/gdpdata",replace


***** create ctax.dta *****
global EUctax CHE DNK ESP EST FIN FRA GBR IRL ISL LVA NOR POL PRT SWE SVN

* create share tempfile 
import excel using "raw_data/ctax.xlsx",sheet(share) first clear 
gather $EUctax, variable(ID) value(share) 
label var share "share of jurisdiction's GHG emissions covered by tax"
tempfile share
save "`share'", replace

* create rate tempfile
import excel using "raw_data/ctax.xlsx",sheet(rate) first clear 
gather $EUctax, variable(ID) value(rate) 
label var rate "carbon tax on 4/1/year (nominal)"
tempfile rate
save "`rate'", replace

* import index data for countries with carbon tax
import excel using "raw_data/ctax.xlsx",sheet(ctax) first clear 
gather $EUctax, variable(ID) value(ctax) 
label var ctax "carbon tax indicator"

* merge with share and rate datasets
merge 1:1 ID year using "`share'"
drop _merge
merge 1:1 ID year using "`rate'"
drop _merge

* save ctax data
sort ID year
save "data/ctax",replace



